<?php
// status.php - public status page

require __DIR__ . '/functions.php';
global $config;

$monitors = load_monitors();

// group by location
$groups = [];
foreach ($monitors as $m) {
    $loc = $m['location'] ?: 'General';
    if (!isset($groups[$loc])) {
        $groups[$loc] = [];
    }
    $groups[$loc][] = $m;
}
ksort($groups);
?>
<!doctype html>
<html lang="en" class="<?= $config['dark_mode'] ? 'dark' : '' ?>">
<head>
    <meta charset="utf-8">
    <title><?= htmlspecialchars($config['brand_name']) ?></title>
    <link rel="stylesheet" href="assets/style.css">
</head>
<body class="status">
<header class="topbar">
    <div class="brand">
        <span class="dot dot-up"></span>
        <?= htmlspecialchars($config['brand_name']) ?>
    </div>
    <div class="subtitle">Live status of monitored services (multi-location via proxies)</div>
</header>

<main class="container">
    <?php foreach ($groups as $location => $items): ?>
        <section class="card">
            <div class="card-header">
                <h2><?= htmlspecialchars($location) ?></h2>
            </div>
            <div class="monitor-grid">
                <?php foreach ($items as $m):
                    $uptime = calculate_uptime_percentage($m);
                    $status = $m['last_status'] ?? 'unknown';
                    $badgeClass = $status === 'up' ? 'badge-up' : ($status === 'down' ? 'badge-down' : 'badge-unknown');
                    ?>
                    <article class="monitor-card">
                        <div class="monitor-header">
                            <div>
                                <div class="monitor-name"><?= htmlspecialchars($m['name']) ?></div>
                                <div class="monitor-target"><?= htmlspecialchars($m['target']) ?></div>
                            </div>
                            <span class="badge <?= $badgeClass ?>"><?= strtoupper($status) ?></span>
                        </div>
                        <div class="monitor-meta">
                            <div>
                                <span class="label">Type</span>
                                <span class="value"><?= htmlspecialchars($m['type']) ?></span>
                            </div>
                            <div>
                                <span class="label">Location</span>
                                <span class="value"><?= htmlspecialchars($m['location'] ?: '-') ?></span>
                            </div>
                            <div>
                                <span class="label">Last check</span>
                                <span class="value"><?= format_timestamp($m['last_check'] ?? null) ?></span>
                            </div>
                            <div>
                                <span class="label">Response time</span>
                                <span class="value">
                                    <?= $m['last_response_time'] ? round($m['last_response_time'], 1) . 'ms' : '-' ?>
                                </span>
                            </div>
                            <div>
                                <span class="label">Uptime</span>
                                <span class="value"><?= $uptime ?>%</span>
                            </div>
                        </div>

                        <?php if (!empty($m['history'])): ?>
                            <div class="uptime-bar">
                                <?php foreach ($m['history'] as $entry):
                                    $cls = ($entry['status'] ?? '') === 'up' ? 'up' : 'down';
                                    ?>
                                    <span class="uptime-block <?= $cls ?>"></span>
                                <?php endforeach; ?>
                            </div>
                        <?php endif; ?>

                        <?php if (!empty($m['last_message'])): ?>
                            <div class="monitor-message">
                                <?= htmlspecialchars($m['last_message']) ?>
                            </div>
                        <?php endif; ?>
                    </article>
                <?php endforeach; ?>
            </div>
        </section>
    <?php endforeach; ?>

    <?php if (empty($groups)): ?>
        <p>No monitors configured yet.</p>
    <?php endif; ?>
</main>
</body>
</html>
