<?php
// run_checks.php - cron entry to run all checks

require __DIR__ . '/functions.php';

$monitors = load_monitors();

foreach ($monitors as &$monitor) {
    if (!empty($monitor['paused'])) {
        continue;
    }

    $type = $monitor['type'] ?? 'http';

    switch ($type) {
        case 'http':
        case 'keyword':
            $res = check_http($monitor);
            break;
        case 'ping':
            $res = check_ping($monitor);
            break;
        case 'port':
            $res = check_port($monitor);
            break;
        case 'cron':
            $res = check_cron($monitor);
            break;
        case 'domain':
            $res = check_domain($monitor);
            break;
        case 'dns':
            $res = check_dns($monitor);
            break;
        case 'ssl':
            $res = check_ssl($monitor);
            break;
        default:
            $res = ['status' => 'down', 'response_time' => null, 'message' => "Unknown type"];
            break;
    }

    $monitor = record_check_result(
        $monitor,
        $res['status'],
        $res['response_time'] ?? null,
        $res['message'] ?? null
    );
}
unset($monitor);

save_monitors($monitors);

echo "Checks completed at " . date('Y-m-d H:i:s') . PHP_EOL;
