#!/usr/bin/env bash
# install_uptime_panel.sh
# Simple installer for the uptime-panel script

set -e

TARGET_DIR=${1:-/var/www/uptime-panel}

echo "Installing uptime-panel into: $TARGET_DIR"

mkdir -p "$TARGET_DIR"
cp -r ./* "$TARGET_DIR"/

cd "$TARGET_DIR"

# Create empty JSON files if missing
[ -f monitors.json ] || echo "[]" > monitors.json
[ -f proxies.json ] || echo "[]" > proxies.json

chmod 664 monitors.json proxies.json || true

echo ""
echo "Done."
echo "Now:"
echo " 1) Edit $TARGET_DIR/config.php  (change admin_password, cron_secret, brand_name, static_proxies if you want)"
echo " 2) Point a vhost or subdomain to $TARGET_DIR"
echo " 3) Open /admin.php to add monitors and proxies."
echo ""
echo "Cron example (every 5 minutes):"
echo "*/5 * * * * /usr/bin/php $TARGET_DIR/run_checks.php >/dev/null 2>&1"
