<?php
// heartbeat.php - cron job heartbeat endpoint

require __DIR__ . '/functions.php';

global $config;

$secret = $_GET['secret'] ?? '';
$id     = $_GET['id'] ?? '';

if ($secret !== $config['cron_secret'] || !$id) {
    http_response_code(403);
    echo "Forbidden";
    exit;
}

$monitors = load_monitors();
$updated = false;

foreach ($monitors as &$m) {
    if ($m['id'] === $id && ($m['type'] ?? '') === 'cron') {
        $m['options']['last_heartbeat'] = now();
        $updated = true;
        break;
    }
}
unset($m);

if ($updated) {
    save_monitors($monitors);
    echo "OK";
} else {
    http_response_code(404);
    echo "Monitor not found or not cron type";
}
